package app.firezone.synk.network.Adapter;




import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;


import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ItemRulesBinding;
import app.firezone.synk.network.model.RulesModel;

import java.util.ArrayList;

public class RulesAdapter extends RecyclerView.Adapter<RulesAdapter.holder> {

    Context  mContext;
    ArrayList<RulesModel> mlists;

    public RulesAdapter(ArrayList<RulesModel> mlists, Context mContext) {
        this.mContext = mContext;
        this.mlists = mlists;
    }

    @NonNull
    @Override
    public holder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(mContext).inflate(R.layout.item_rules,parent,false);
        return new holder(view);
    }

    @Override
    public void onBindViewHolder(@NonNull holder holder, @SuppressLint("RecyclerView") int position) {

        RulesModel model = mlists.get(position);

        holder.binding.titleTxt.setText(model.getRules());

    }

    @Override
    public int getItemCount() {
        return mlists.size();
    }

    public class holder extends RecyclerView.ViewHolder {


        ItemRulesBinding binding;

        public holder(@NonNull View itemView) {
            super(itemView);

            binding = ItemRulesBinding.bind(itemView);

        }
    }
}
